<?php
include '../config.php'; // Load configuration settings

// Get the current domain
$domain = $_SERVER['HTTP_HOST'];

// Generate URLs using the domain and parameters from config.php
$url_for_spam = "https://{$domain}/?{$parameter_spam}";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Scam Information</title>
    <style>
        body {
            background-color: #000000; /* Pure black background */
            color: #ffffff;
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            flex-direction: column; /* Align button above container */
        }
        
        .container {
            display: grid;
            grid-template-columns: 1fr;
            gap: 20px;
            max-width: 500px;
            width: 100%;
            padding: 20px;
            border-radius: 10px;
            background-color: #1a1a1a; /* Dark gray background */
            box-shadow: 0 0 15px rgba(255, 255, 255, 0.2); /* Soft white glow */
        }
        
        .title {
            text-align: center;
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 10px;
            color: #ffffff;
            text-shadow: 0 0 8px rgba(255, 255, 255, 0.7); /* Neon glow effect */
        }

        .field {
            display: flex;
            flex-direction: column;
            background-color: #1a1a1a;
            padding: 15px;
            border-radius: 8px;
            box-shadow: inset 0 0 10px rgba(255, 255, 255, 0.1); /* Soft inner white glow */
        }

        .field-label {
            font-size: 16px;
            font-weight: bold;
            color: #d3d3d3; /* Light gray for label */
            margin-bottom: 5px;
            text-shadow: 0 0 5px rgba(255, 255, 255, 0.5); /* Subtle glow */
        }

        .field-value {
            font-size: 18px;
            color: #ffffff;
            text-shadow: 0 0 8px rgba(255, 255, 255, 0.8); /* Bright white neon glow */
        }

        .back-button {
            margin-bottom: 20px;
            padding: 10px 20px;
            color: #ffffff;
            background-color: #333;
            border: none;
            border-radius: 5px;
            font-weight: bold;
            font-size: 16px;
            text-decoration: none;
            text-align: center;
            box-shadow: 0 0 10px rgba(255, 255, 255, 0.3); /* Neon glow effect */
            transition: background-color 0.3s;
            text-shadow: 0 0 8px rgb(255 255 255 / 80%);
        }

        .back-button:hover {
            background-color: #444; /* Slightly lighter on hover */
            box-shadow: 0 0 15px rgba(255, 255, 255, 0.5); /* Brighter glow on hover */
        }
    </style>
</head>
<body>

<a href="dashboard.php" class="back-button">Back to Dashboard</a> <!-- Back to Dashboard Button -->

<div class="container">
    <div class="title">Scam Information</div>

    <div class="field">
        <div class="field-label">URL For Spam :</div>
        <div class="field-value"><?php echo htmlspecialchars($url_for_spam); ?></div>
    </div>

    <div class="field">
        <div class="field-label">Domain:</div>
        <div class="field-value"><?php echo htmlspecialchars($domain); ?></div>
    </div>
</div>

</body>
</html>
