<?php
session_start();

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

header("Refresh: 3; url=dashboard.php"); 
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>AILYS | Authorizing...</title>
  <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;600;900&display=swap" rel="stylesheet">
  <style>
    :root {
        --pink-main: #ff69b4;
        --pink-glow: #ff1493;
        --bg-dark: #0a0508;
    }

    * { margin: 0; padding: 0; box-sizing: border-box; }

    body {
        font-family: 'Orbitron', sans-serif;
        background-color: var(--bg-dark);
        height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        color: #fff;
        position: relative;
        overflow: hidden;
        flex-direction: column;
    }

    #particles-js {
        position: absolute;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        z-index: -1;
        background-image: radial-gradient(circle, #1a0a12 0%, #000000 100%);
    }

    .loading-container {
        width: 100%;
        max-width: 400px;
        text-align: center;
        z-index: 10;
    }

    .loading-message {
        font-size: 18px;
        color: var(--pink-main);
        text-shadow: 0 0 15px var(--pink-glow);
        margin-bottom: 25px;
        letter-spacing: 5px;
        text-transform: uppercase;
    }

    .progress-container {
        width: 100%;
        height: 6px;
        background-color: rgba(255, 105, 180, 0.1);
        border-radius: 10px;
        overflow: hidden;
        border: 1px solid rgba(255, 105, 180, 0.2);
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);
    }

    .progress-bar {
        width: 0;
        height: 100%;
        background: linear-gradient(90deg, var(--pink-main), var(--pink-glow));
        border-radius: 10px;
        transition: width 3s cubic-bezier(0.42, 0, 0.58, 1);
        box-shadow: 0 0 20px var(--pink-glow);
    }

    .status-text {
        margin-top: 15px;
        font-size: 10px;
        color: #888;
        letter-spacing: 2px;
        text-transform: uppercase;
    }
  </style>
</head>
<body>
    <div id="particles-js"></div>

    <div class="loading-container">
        <div class="loading-message">
            Initializing System
        </div>
        <div class="progress-container">
            <div class="progress-bar"></div>
        </div>
        <div class="status-text">Synchronizing Secure Connection...</div>
    </div>

    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>

    <script>
        particlesJS("particles-js", {
            "particles": {
                "number": { "value": 80, "density": { "enable": true, "value_area": 800 } },
                "color": { "value": "#ff69b4" },
                "shape": { "type": "circle" },
                "opacity": { "value": 0.5, "random": false },
                "size": { "value": 2, "random": true },
                "line_linked": { "enable": true, "distance": 150, "color": "#ff69b4", "opacity": 0.3, "width": 1 },
                "move": { "enable": true, "speed": 3, "direction": "none", "random": false, "straight": false, "out_mode": "out", "bounce": false }
            },
            "interactivity": {
                "events": { "onhover": { "enable": true, "mode": "repulse" } },
                "modes": { "repulse": { "distance": 100, "duration": 0.4 } }
            },
            "retina_detect": true
        });

        window.onload = function() {
            setTimeout(() => {
                document.querySelector('.progress-bar').style.width = '100%';
            }, 100);
        };
    </script>
</body>
</html>