<?php
session_start();

$assets = "https://" . $_SERVER['SERVER_NAME'] . "/agent007/css";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $inputApiKey = $_POST['login-key'];
    
    $apiKey = trim(file_get_contents('key.txt'));
    
    if ($inputApiKey === $apiKey) {
        $_SESSION['logged_in'] = true;
        header('Location: loading.php');
        exit();
    } else {
        $error = "ACCESS DENIED: Invalid Login Key!";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LOGIN | AILYS PINK</title>
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;600;900&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <style>
        :root {
            --pink-main: #ff69b4;
            --pink-glow: #ff1493;
            --bg-dark: #0a0508;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }

        body, html {
            height: 100%;
            font-family: 'Poppins', sans-serif;
            background-color: var(--bg-dark);
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        #particles-js {
            position: absolute;
            width: 100%;
            height: 100%;
            background-image: radial-gradient(circle, #1a0a12 0%, #000000 100%);
            z-index: 1;
        }

        .login-container {
            position: relative;
            z-index: 2;
            width: 100%;
            max-width: 400px;
            padding: 20px;
        }

        .login-box {
            background: rgba(255, 105, 180, 0.05);
            backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 105, 180, 0.3);
            border-radius: 20px;
            padding: 40px;
            text-align: center;
            box-shadow: 0 0 40px rgba(0, 0, 0, 0.5), inset 0 0 15px rgba(255, 105, 180, 0.1);
        }

        .login-title {
            font-family: 'Orbitron', sans-serif;
            font-size: 22px;
            letter-spacing: 3px;
            color: var(--pink-main);
            margin-bottom: 30px;
            text-shadow: 0 0 10px var(--pink-glow);
        }

        .input-container {
            margin-bottom: 25px;
        }

        input[type="password"] {
            width: 100%;
            padding: 15px;
            border-radius: 10px;
            border: 1px solid rgba(255, 105, 180, 0.4);
            background: rgba(0, 0, 0, 0.5);
            color: #fff;
            font-family: 'Orbitron', sans-serif;
            text-align: center;
            outline: none;
            transition: 0.3s;
            letter-spacing: 2px;
        }

        input[type="password"]:focus {
            border-color: var(--pink-main);
            box-shadow: 0 0 15px rgba(255, 105, 180, 0.3);
            background: rgba(0, 0, 0, 0.7);
        }

        .login-button {
            width: 100%;
            padding: 15px;
            border: none;
            border-radius: 10px;
            background: var(--pink-main);
            color: white;
            font-family: 'Orbitron', sans-serif;
            font-weight: 900;
            cursor: pointer;
            transition: 0.3s;
            text-transform: uppercase;
            box-shadow: 0 0 15px rgba(255, 105, 180, 0.4);
        }

        .login-button:hover {
            background: var(--pink-glow);
            box-shadow: 0 0 25px var(--pink-main);
            transform: translateY(-2px);
        }

        .error {
            background: rgba(255, 0, 0, 0.2);
            color: #ff4d4d;
            padding: 10px;
            border-radius: 8px;
            font-size: 12px;
            margin-bottom: 20px;
            border: 1px solid #ff4d4d;
            font-family: 'Orbitron', sans-serif;
        }
    </style>
</head>
<body>
    
    <div id="particles-js"></div>

    <div class="login-container">
        <div class="login-box">
            <h2 class="login-title">ADMIN AUTH</h2>
            
            <?php if (isset($error)): ?>
                <div class="error"><?= $error; ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="input-container">
                    <input type="password" id="login-key" name="login-key" required placeholder="••••••••••••">
                </div>
                <button type="submit" class="login-button">ENTER SYSTEM</button>
            </form>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script>
        particlesJS("particles-js", {
            "particles": {
                "number": { "value": 80, "density": { "enable": true, "value_area": 800 } },
                "color": { "value": "#ff69b4" },
                "shape": { "type": "circle" },
                "opacity": { "value": 0.3, "random": true },
                "size": { "value": 2, "random": true },
                "line_linked": { 
                    "enable": true, 
                    "distance": 150, 
                    "color": "#ff69b4", 
                    "opacity": 0.2, 
                    "width": 1 
                },
                "move": { "enable": true, "speed": 1.5, "direction": "none", "random": true, "straight": false, "out_mode": "out", "bounce": false }
            },
            "interactivity": {
                "events": {
                    "onhover": { "enable": true, "mode": "grab" },
                    "onclick": { "enable": true, "mode": "push" }
                },
                "modes": {
                    "grab": { "distance": 200, "line_linked": { "opacity": 0.5 } }
                }
            },
            "retina_detect": true
        });
    </script>
</body>
</html>