<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Logging out...</title>
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;600;900&family=Poppins:wght@300;400&display=swap" rel="stylesheet">
    <style>
        :root {
            --pink-main: #ff69b4;
            --pink-glow: #ff1493;
            --bg-dark: #0a0508;
        }

        body {
            background-color: var(--bg-dark);
            color: #ffffff;
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            text-align: center;
            overflow: hidden;
        }

        #particles-js {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: -1;
            background-image: radial-gradient(circle, #1a0a12 0%, #000000 100%);
        }

        .container {
            background: rgba(45, 19, 32, 0.6);
            backdrop-filter: blur(15px);
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0px 0px 30px rgba(255, 105, 180, 0.2);
            border: 1px solid var(--pink-main);
            max-width: 450px;
            width: 90%;
            animation: pulse-border 2s infinite;
        }

        @keyframes pulse-border {
            0% { border-color: rgba(255, 105, 180, 0.4); box-shadow: 0 0 20px rgba(255, 105, 180, 0.1); }
            50% { border-color: var(--pink-main); box-shadow: 0 0 40px rgba(255, 105, 180, 0.3); }
            100% { border-color: rgba(255, 105, 180, 0.4); box-shadow: 0 0 20px rgba(255, 105, 180, 0.1); }
        }

        .logout-text {
            font-family: 'Orbitron', sans-serif;
            font-size: 20px;
            font-weight: 900;
            color: var(--pink-main);
            text-transform: uppercase;
            letter-spacing: 2px;
            margin-bottom: 10px;
            text-shadow: 0 0 10px var(--pink-glow);
        }

        .redirect-message {
            font-size: 14px;
            font-weight: 300;
            color: #ffc0cb;
            letter-spacing: 1px;
        }

        .dots::after {
            content: '';
            animation: dots 1.5s infinite;
        }

        @keyframes dots {
            0% { content: '.'; }
            33% { content: '..'; }
            66% { content: '...'; }
        }
    </style>
</head>
<body>

    <div id="particles-js"></div>

    <div class="container">
        <p class="logout-text">Session Terminated</p>
        <div class="redirect-message">Disconnecting from AILYS Core<span class="dots"></span></div>
    </div>

    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>

    <script>
        particlesJS("particles-js", {
            "particles": {
                "number": { "value": 60, "density": { "enable": true, "value_area": 800 } },
                "color": { "value": "#ff69b4" },
                "shape": { "type": "circle" },
                "opacity": { "value": 0.4, "random": true },
                "size": { "value": 2, "random": true },
                "line_linked": { "enable": true, "distance": 150, "color": "#ff69b4", "opacity": 0.2, "width": 1 },
                "move": { "enable": true, "speed": 1, "direction": "top", "random": true, "straight": false, "out_mode": "out", "bounce": false }
            },
            "interactivity": {
                "events": { "onhover": { "enable": false }, "onclick": { "enable": false } }
            },
            "retina_detect": true
        });

        setTimeout(function() {
            window.location.href = "index.php";
        }, 3000);
    </script>

</body>
</html>